initializeSetup( access, player )
{
    if( level.status[ access ] == player.access && !player isHost() && isDefined(player.access) )
        return self iprintln(player getName() + " is already this access level.");
    if( isDefined(player.access) && player.access == level.status[ 3 ] )
        return self iprintln("You can not edit players with access level Host.");    
            
    player notify("end_menu");
    player.access = level.status[ access ];
    
    if( player isMenuOpen() )
        player menuClose();

    player.menu = [];
    player.previousMenu = [];
    player.menu["isOpen"] = false;
    player.menu["isLocked"] = false;

    if( !isDefined(player.menu["current"]) )
         player.menu["current"] = "main";
        
    player menuOptions();
    player thread menuMonitor();
}

newMenu( menu )
{
    if(!isDefined( menu ))
    {
        menu = self.previousMenu[ self.previousMenu.size -1 ];
        self.previousMenu[ self.previousMenu.size -1 ] = undefined;
    }
    else 
        self.previousMenu[ self.previousMenu.size ] = self getCurrentMenu();
        
    self setCurrentMenu( menu );
    self menuOptions();
    self setMenuText();
    self refreshTitle();
    self updateScrollbar();
}

addMenu( menu, title )
{
    self.storeMenu = menu;
    if(self getCurrentMenu() != menu)
        return;
        
    self.eMenu = [];
    self.menuTitle = title;
    if(!isDefined(self.menu[ menu + "_cursor"]))
        self.menu[ menu + "_cursor"] = 0;
    if(!IsDefined(self.menu[ "submenu_cursor" ]))   
        self.menu[ "submenu_cursor" ] = 0;
}

addOpt( opt, func, p1, p2, p3, p4, p5 )
{
    if(self.storeMenu != self getCurrentMenu())
        return;
    option      = spawnStruct();
    option.opt  = opt;
    option.func = func;
    option.p1   = p1;
    option.p2   = p2;
    option.p3   = p3;
    option.p4   = p4;
    option.p5   = p5;
    self.eMenu[self.eMenu.size] = option;
}

addOptDesc( opt, title, shader, desc, func, p1, p2, p3, p4, p5 )
{
    if(self.storeMenu != self getCurrentMenu())
        return;
    option        = spawnStruct();
    option.opt    = opt;
    option.title  = title;
    option.shader = shader;
    option.desc   = desc;
    
    option.func   = func;
    option.p1     = p1;
    option.p2     = p2;
    option.p3     = p3;
    option.p4     = p4;
    option.p5     = p5;
    self.eMenu[self.eMenu.size] = option;
}

setCurrentMenu( menu )
{
    self.menu["current"] = menu;
}

getCurrentMenu()
{
    return self.menu["current"];
}

getCursor()
{
    return self.menu[ self getCurrentMenu() + "_cursor" ];
}

isMenuOpen()
{
    if( !isDefined(self.menu["isOpen"]) || !self.menu["isOpen"] )
        return false;
    return true;
}

refreshMenu()
{
    if(self isMenuOpen())
    {
        self destroyMenu();
        self drawText( 0, 1 );
    }
}

destroyMenu(all)
{
    self destroyAll(self.menu["OPT"]);
    
    if(isDefined(all))
    {
        self destroyAll(self.menu["OPT"]);
        self.menu["isOpen"] = undefined;
    }
}